<?php

namespace App\Models\CaseSetting;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CaseSetting extends Model 
{

    protected $table = 'case_settings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('case_status_id', 'adjournment_status_id', 'case_end_reason_id');

    public function caseStatus()
    {
        return $this->hasMany('CaseStatuse');
    }

    public function adjournmentStatus()
    {
        return $this->hasMany('AdjournmentStatuse');
    }

    public function caseEndResason()
    {
        return $this->hasMany('CaseEndReason');
    }

}